import React, { useEffect } from "react";
import { View, Text, Pressable } from "react-native";
import DeliveryOptionStyle from "./DeliveryOptionStyle";
import EditIcon from "../../../../../assets/svgs/profile/edit profile.svg";
import useProcessPrice from "../../../../../hooks/useProcessPrice";
import { useNavigation } from "@react-navigation/native";
import { useDispatch, useSelector } from "react-redux";
import {
    getShipping,
    setDeliveryAddress,
} from "../../../../../redux/slices/featureProducts/deliveryOption/getShipping";
import useAuth from "../../../../../hooks/useAuth";
import { BASE_API_URL_STG } from "@env";
import { memo } from "react";
import useLangTranslation from "../../../../../hooks/useLangTranslation";
import CustomSVG from "../../../../../src/components/CustomSVG/CustomSVG";

const DeliveryOptions = ({ productDetails }) => {
    const navigation = useNavigation();
    const dispatch = useDispatch();
    const { access_token } = useAuth();
    const { trans } = useLangTranslation();
    const {
        id,
        estimated_delivery,
        estimated_delivery_unit,
        warranty_type,
        warranty_period,
        warranty_policy,
        type,
        meta,
    } = productDetails?.data || {};
    const processPrice = useProcessPrice();
    const { data, deliveryAddress, loading } = useSelector(
        (state) => state.getShippingReducer
    );
    const { defaultAddress } = useSelector((state) => state.getMyAddress);

    useEffect(() => {
        dispatch(setDeliveryAddress(defaultAddress));
    }, [defaultAddress]);

    useEffect(() => {
        let isMounted = true;
        if (isMounted) {
            const url = `${BASE_API_URL_STG}/user/get-shipping?country=${deliveryAddress?.country}&state=${deliveryAddress?.state}&city=${deliveryAddress?.city}&product_id=${id}`;
            dispatch(getShipping({ access_token, url }));
        }
        return () => {
            isMounted = false;
        };
    }, [deliveryAddress]);

    const handleEditAddress = () => {
        navigation.navigate("select delivery address");
    };

    return (
        <>
            <View style={DeliveryOptionStyle.container}>
                <View style={DeliveryOptionStyle.subCont}>
                    {type !== "External/Affiliate Product" && (
                        <>
                            {data?.status == 1 && (
                                <View>
                                    <View style={DeliveryOptionStyle.title}>
                                        <Text style={ DeliveryOptionStyle.textTitle }>
                                            {trans("Delivery Options")}
                                        </Text>
                                        <Pressable onPress={handleEditAddress}>
                                            <CustomSVG svgIcon={EditIcon} />
                                        </Pressable>
                                    </View>

                                    {Object.keys(deliveryAddress).length >
                                        0 && (
                                        <Text
                                            style={DeliveryOptionStyle.address}
                                        >
                                            {`${deliveryAddress?.country_name}, ${deliveryAddress?.state_name}, ${deliveryAddress?.city}`}
                                        </Text>
                                    )}
                                    <View
                                        style={[
                                            DeliveryOptionStyle.delivery,
                                            DeliveryOptionStyle.mt18(type)
                                        ]}
                                    >
                                        {Object.keys(data).length > 0 && (
                                            <Text
                                                style={
                                                    DeliveryOptionStyle.deliveryText
                                                }
                                            >
                                                {trans(data.name)}
                                            </Text>
                                        )}
                                        {Object.keys(data).length > 0 && (
                                            <Text
                                                style={
                                                    DeliveryOptionStyle.deliveryInfo
                                                }
                                            >
                                                {loading
                                                    ? trans("Loading") + "..."
                                                    : processPrice(
                                                          data.amount
                                                      ) + " "}
                                                {estimated_delivery != "" &&
                                                    `(${estimated_delivery} ${trans(estimated_delivery_unit)})`}
                                            </Text>
                                        )}
                                    </View>
                                </View>
                            )}
                            <View style={[DeliveryOptionStyle.delivery, DeliveryOptionStyle.mt5]}>
                                <Text style={DeliveryOptionStyle.deliveryText}>
                                    {trans("Cash on Delivery")}
                                </Text>
                                <Text style={DeliveryOptionStyle.deliveryInfo}>
                                    {meta.cash_on_delivery == 1 ? trans("Available") : trans("Not Available")}
                                </Text>
                            </View>
                        </>
                    )}
                    <View
                        style={[
                            DeliveryOptionStyle.delivery,
                            DeliveryOptionStyle.mt18(type)
                        ]}
                    >
                        <Text style={DeliveryOptionStyle.deliveryText}>
                            {trans("Warranty")}
                        </Text>
                        <View>
                            {warranty_period != "" && (
                                <Text style={DeliveryOptionStyle.deliveryInfo}>
                                    {trans(warranty_period)}
                                </Text>
                            )}
                            {warranty_type != "" && (
                                <Text style={[
                                    DeliveryOptionStyle.deliveryInfo,
                                    DeliveryOptionStyle.grayColor
                                ]}>
                                    {warranty_type}
                                </Text>
                            )}
                            {warranty_policy != "" && (
                                <Text
                                    numberOfLines={1}
                                    style={[
                                        DeliveryOptionStyle.deliveryInfo,
                                        DeliveryOptionStyle.grayColor,
                                    ]}
                                >
                                    {warranty_policy}
                                </Text>
                            )}
                        </View>
                    </View>
                </View>
            </View>
        </>
    );
};

export default memo(DeliveryOptions);
